<?php

// src/DgclProjectsBundle/Form/RegistrationType.php

namespace Dgcl\ProjectsBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;

class UserType extends AbstractType {

    public function buildForm(FormBuilderInterface $builder, array $options) {

        
        $builder->add('Commune');
        
        $builder->add('roles', 'choice', array(
            
            'choices' => array(
                'ROLE_ADMIN' => 'DGCL',
                'ROLE_COMMUNE' => 'Communes',
                'ROLE_CGSP' => 'CGSP',
                'ROLE_CPSCL' => 'CPSCL',
                'ROLE_CDC' => 'CDC'
                ),
            
            'multiple' => true,
            
        ));
        
    }

    public function getParent() {
        //return 'FOS\UserBundle\Form\Type\RegistrationFormType';
        return 'fos_user_registration';
    }

    public function getBlockPrefix() {
        return 'app_user_type';
    }

    // For Symfony 2.x
    public function getName() {
        return $this->getBlockPrefix();
    }

}