<?php

namespace Dgcl\ProjectsBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use Dgcl\ProjectsBundle\Entity\Utils;

class QuestionnaireType extends AbstractType {

    public $axe;

    public function __construct($axe) {


        $this->axe = $axe;
    }

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options) {


        if ($this->axe == 'domaine_1_axe_1') {

            $builder
                    ->add('question_1_1_1', 'choice', array('required' => true, 'choices' => Utils::getChoices04()))
                    ->add('question_1_1_2', 'choice', array('required' => true, 'choices' => Utils::getMois(), 'multiple' => true, 'expanded' => true))
                    ->add('question_1_1_3', 'choice', array('required' => true, 'choices' => Utils::getChoicesQuestion_1_1_3(), 'multiple' => false, 'expanded' => true))
                    ->add('question_1_2_1', 'choice', array('required' => true, 'choices' => Utils::getChoices04()))
                    ->add('question_1_2_2', 'choice', array('required' => true, 'choices' => Utils::getMois(), 'multiple' => true, 'expanded' => true))
                    ->add('question_1_2_3', 'choice', array('required' => true, 'choices' => Utils::getChoicesQuestion_1_2_3(), 'multiple' => false, 'expanded' => true))
                    ->add('question_1_3_1', null, array('required' => true))
                    ->add('question_1_3_2', 'choice', array('required' => true, 'choices' => Utils::getChoicesQuestion_1_3_2(), 'multiple' => false, 'expanded' => true))
            ;
        }


        if ($this->axe == 'domaine_1_axe_2') {

            $builder
                    ->add('question_2_1_1', 'choice', array('required' => true, 'choices' => Utils::getYesNo(), 'multiple' => false, 'expanded' => true))
                    ->add('question_2_1_2', 'text', array('required' => true))
                    ->add('question_2_1_3', 'choice', array('required' => true, 'choices' => Utils::getChoicesQuestion_2_1_3(), 'multiple' => false, 'expanded' => true))
                    ->add('question_2_2_1')
                    ->add('question_2_2_2', 'choice', array('required' => true, 'choices' => Utils::getChoicesQuestion_2_2_2(), 'multiple' => false, 'expanded' => true))
            ;
        }


        if ($this->axe == 'domaine_1_axe_3') {

            $builder
                    ->add('question_3_1_1', 'choice', array('required' => true, 'choices' => Utils::getYesNo(), 'multiple' => false, 'expanded' => true))
                   
                    ->add('question_3_1_2_R_1', 'text', array('required' => true))
                    ->add('question_3_1_2_R_2', 'text', array('required' => true))
                    ->add('question_3_1_2_R_3', 'text', array('required' => true))
                    ->add('question_3_1_2_R_4', 'text', array('required' => true))
                    
                    ->add('question_3_1_3', 'choice', array('required' => false, 'choices' => Utils::getChoicesQuestion_3_1_3(), 'multiple' => true, 'expanded' => true))
                    ->add('question_3_2_1', 'choice', array('required' => true, 'choices' => Utils::getYesNo(), 'multiple' => false, 'expanded' => true))
                    ->add('question_3_2_2', 'choice', array('required' => true, 'choices' => Utils::getYesNo(), 'multiple' => false, 'expanded' => true))
                    ->add('question_3_2_3', 'choice', array('required' => true, 'choices' => Utils::getChoicesQuestion_3_2_3(), 'multiple' => false, 'expanded' => true))
                    ->add('question_3_3_1', 'text', array('required' => true))
                    ->add('question_3_3_2', 'text', array('required' => true))
                    ->add('question_3_3_3', 'text', array('required' => true))
                    ->add('question_3_3_4', 'text', array('required' => true))
                    ->add('question_3_3_5', 'text', array('required' => true))
            ;
        }


        if ($this->axe == 'domaine_2_axe_1') {

            $builder
                    ->add('question_4_1_1', 'choice', array('required' => true, 'choices' => Utils::getYesNo(), 'multiple' => false, 'expanded' => true))
                    ->add('question_4_1_2', 'choice', array('required' => true, 'choices' => Utils::getYesNo(), 'multiple' => false, 'expanded' => true))
                    ->add('question_4_1_3', 'choice', array('required' => true, 'choices' => Utils::getChoicesQuestion_4_1_3(), 'multiple' => false, 'expanded' => true))
                    ->add('question_4_2_1', 'choice', array('required' => true, 'choices' => Utils::getYesNo(), 'multiple' => false, 'expanded' => true))
                    ->add('question_4_2_2', 'choice', array('required' => true, 'choices' => Utils::getYesNo(), 'multiple' => false, 'expanded' => true))
                    ->add('question_4_2_3', 'choice', array('required' => true, 'choices' => Utils::getChoicesQuestion_4_2_3(), 'multiple' => false, 'expanded' => true))
            ;
        }

        if ($this->axe == 'domaine_2_axe_2') {

            $builder
                    ->add('question_5_1_1', 'text', array('required' => true))
                    ->add('question_5_1_2', 'text', array('required' => true))
                    ->add('question_5_1_3', 'text', array('required' => true))
                    ->add('question_5_2_1', 'text', array('required' => true))
                    ->add('question_5_2_2', 'text', array('required' => true))
                    ->add('question_5_2_3', 'text', array('required' => true));
        }


        if ($this->axe == 'domaine_2_axe_3') {

            $builder
                    ->add('question_6_1_1', 'choice', array('required' => true, 'choices' => Utils::getYesNo(), 'multiple' => false, 'expanded' => true))
                    ->add('question_6_1_2', 'choice', array('required' => true, 'choices' => Utils::getChoicesQuestion_6_1_2(), 'multiple' => false, 'expanded' => true))
                    ->add('question_6_2_1', 'text', array('required' => true))
                    ->add('question_6_2_2', 'text', array('required' => true))
                    ->add('question_6_2_3', 'text', array('required' => true))
                    ->add('question_6_2_4', 'text', array('required' => true))
                    ->add('question_6_2_5', 'text', array('required' => true))
                    ->add('question_6_2_6', 'text', array('required' => true))
                    ->add('question_6_2_7', 'text', array('required' => true))
                    ->add('question_6_3_1', 'text', array('required' => true))
                    ->add('question_6_3_2', 'text', array('required' => true))
                    ->add('question_6_3_3', 'text', array('required' => true))
                    ->add('question_6_4_1', 'text', array('required' => true))
                    ->add('question_6_4_2', 'text', array('required' => true))
                    ->add('question_6_4_3', 'text', array('required' => true))

            ;
        }

        if ($this->axe == 'domaine_3_axe_1') {

            $builder
                    ->add('question_7_1_1', 'choice', array('required' => true, 'choices' => Utils::getYesNo(), 'multiple' => false, 'expanded' => true))
                    ->add('question_7_1_2', 'choice', array('required' => true, 'choices' => Utils::getYesNo(), 'multiple' => false, 'expanded' => true))
                    ->add('question_7_2_1', 'text', array('required' => true))
                    ->add('question_7_2_2', 'text', array('required' => true))
                    ->add('question_7_2_3', 'text', array('required' => true))
                    ->add('question_7_2_4', 'text', array('required' => true))
                    ->add('question_7_3_1', 'text', array('required' => true))
                    ->add('question_7_3_2', 'text', array('required' => true))
                    ->add('question_7_3_3', 'text', array('required' => true))
                    ->add('question_7_3_4', 'text', array('required' => true))
            ;
        }

        if ($this->axe == 'domaine_3_axe_2') {

            $builder
                    ->add('question_8_1_1', 'choice', array('required' => true, 'choices' => Utils::getYesNo(), 'multiple' => false, 'expanded' => true))
                    ->add('question_8_1_2', 'choice', array('required' => true, 'choices' => Utils::getChoicesQuestion_8_1_2(), 'multiple' => false, 'expanded' => true))
                    ->add('question_8_1_3', 'choice', array('required' => true, 'choices' => Utils::getChoicesQuestion_8_1_3(), 'multiple' => false, 'expanded' => true))

                    ->add('question_8_2_1_R_1', 'text', array('required' => true))
                    ->add('question_8_2_1_R_2', 'text', array('required' => true))
                    ->add('question_8_2_1_R_3', 'text', array('required' => true))
                    
                    ->add('question_8_2_2', 'choice', array('required' => true, 'choices' => Utils::getYesNo(), 'multiple' => false, 'expanded' => true))
                    
                    ->add('question_8_3_1_R_1', 'text', array('required' => true))
                    ->add('question_8_3_1_R_2', 'text', array('required' => true))
                    ->add('question_8_3_1_R_3', 'text', array('required' => true))
                    
                    ->add('question_8_3_2_R_1', 'text', array('required' => true))
                    ->add('question_8_3_2_R_2', 'text', array('required' => true))
                    ->add('question_8_3_2_R_3', 'text', array('required' => true))
                    
                    ->add('question_8_3_3', 'text', array('required' => true))
            ;
        }

        if ($this->axe == 'domaine_3_axe_3') {

            $builder
                    ->add('question_9_1_1', 'choice', array('required' => true, 'choices' => Utils::getYesNo(), 'multiple' => false, 'expanded' => true))
                    ->add('question_9_1_2', 'choice', array('required' => true, 'choices' => Utils::getYesNo(), 'multiple' => false, 'expanded' => true))
                    
                    ->add('question_9_2_1_R_1', 'text', array('required' => true))
                    ->add('question_9_2_1_R_2', 'text', array('required' => true))
                    ->add('question_9_2_1_R_3', 'text', array('required' => true))
                    ->add('question_9_2_1_R_4', 'text', array('required' => true))
                    ->add('question_9_2_1_R_5', 'text', array('required' => true))
                    
                    ->add('question_9_2_2_R_1', 'text', array('required' => true))
                    ->add('question_9_2_2_R_2', 'text', array('required' => true))
                    ->add('question_9_2_2_R_3', 'text', array('required' => true))
                    ->add('question_9_2_2_R_4', 'text', array('required' => true))
                    ->add('question_9_2_2_R_5', 'text', array('required' => true))
                    
                    ->add('question_9_2_3', 'text', array('required' => true))
                    
                    ->add('question_9_3_1_R_1', 'text', array('required' => true))
                    ->add('question_9_3_1_R_2', 'text', array('required' => true))
                    ->add('question_9_3_1_R_3', 'text', array('required' => true))
                    ->add('question_9_3_1_R_4', 'text', array('required' => true))
                    ->add('question_9_3_1_R_5', 'text', array('required' => true))
                    
                    ->add('question_9_3_2', 'text', array('required' => true))
            ;
        }

        if ($this->axe == 'domaine_3_axe_4') {

            $builder
                    ->add('question_10_1_1',  'choice', array('required' => true, 'choices' => Utils::getYesNo(), 'multiple' => false, 'expanded' => true))
                    ->add('question_10_1_2',  'choice', array('required' => true, 'choices' => Utils::getChoicesQuestion_10_1_2(), 'multiple' => false, 'expanded' => true))
                    ->add('question_10_1_3',  'choice', array('required' => true, 'choices' => Utils::getYesNo(), 'multiple' => false, 'expanded' => true))
                    ->add('question_10_1_4',  'choice', array('required' => true, 'choices' => Utils::getYesNo(), 'multiple' => false, 'expanded' => true))
                    ->add('question_10_1_5',  'choice', array('required' => true, 'choices' => Utils::getChoices04()))
                    ->add('question_10_1_6',  'choice', array('required' => true, 'choices' => Utils::getChoicesQuestion_10_1_6(), 'multiple' => false, 'expanded' => true))
            ;
        }
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver) {
        $resolver->setDefaults(array(
            'data_class' => 'Dgcl\ProjectsBundle\Entity\Questionnaire'
        ));
    }

    /**
     * @return string
     */
    public function getName() {
        return 'dgcl_projectsbundle_questionnaire';
    }

}
