<?php

namespace Dgcl\ProjectsBundle\Entity;

use FOS\UserBundle\Model\User as BaseUser;

/**
 * User
 */
class User extends BaseUser
{
    public function __construct()
    {
        parent::__construct();
        // your own logic
    }
    /**
     * @var integer
     */
    protected $id;


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }
    
    /**
    * Overriding Fos User class due to impossible to set default role ROLE_USER 
    * @see User at line 138
    * @link https://github.com/FriendsOfSymfony/FOSUserBundle/blob/master/Model/User.php#L138
    * {@inheritdoc}
    */
    public function addRole($role)
    {
        $role = strtoupper($role);

        if (!in_array($role, $this->roles, true)) {
            $this->roles[] = $role;
        }

        return $this;
    }
    
    
    
    
    
    
    /**
     * @var \Dgcl\ProjectsBundle\Entity\Commune
     */
    private $Commune;


    /**
     * Set Commune
     *
     * @param \Dgcl\ProjectsBundle\Entity\Commune $commune
     * @return User
     */
    public function setCommune(\Dgcl\ProjectsBundle\Entity\Commune $commune = null)
    {
        $this->Commune = $commune;
    
        return $this;
    }

    /**
     * Get Commune
     *
     * @return \Dgcl\ProjectsBundle\Entity\Commune 
     */
    public function getCommune()
    {
        return $this->Commune;
    }
}