<?php

namespace Dgcl\ProjectsBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Dgcl\ProjectsBundle\Entity\User;
use Dgcl\ProjectsBundle\Form\UserType;


/**
 * User controller.
 *
 */
class UserController extends Controller {

    public function indexAction()
    {
        if (!$this->get('security.context')->isGranted(array( 'ROLE_ADMIN' ) )) {
            $this->get('session')->getFlashBag()->add(
                    'error', $this->get('translator')->trans('permission denied')
            );
           return $this->redirect($this->generateUrl('Dgcl_project_default'));
        }
        
        $em = $this->getDoctrine()->getManager();

        //$entities = $em->getRepository('DgclProjectsBundle:User')->findAll();
        
        $query = $em->createQuery(
                'SELECT u FROM DgclProjectsBundle:User u WHERE u.roles not LIKE :role')
            ->setParameter('role', '%"ROLE_SUPER_ADMIN"%');

        $entities = $query->getResult();
         
        return $this->render('DgclProjectsBundle:User:index.html.twig', array(
            'entities' => $entities
        ));
     }
     
    public function addAction(Request $request) {

        if (!$this->get('security.context')->isGranted('ROLE_ADMIN')) {
            $this->get('session')->getFlashBag()->add(
                    'error', $this->get('translator')->trans('permission denied')
            );
            return $this->redirect($this->generateUrl('Dgcl_project_default'));
        }

        $entity = new User();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        return $this->render('DgclProjectsBundle:User:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }
     
     /**
     * Creates a new User entity.
     *
     */
    public function createAction(Request $request) {

        if (!$this->get('security.context')->isGranted('ROLE_ADMIN')) {
            $this->get('session')->getFlashBag()->add(
                    'error', $this->get('translator')->trans('permission denied')
            );
            return $this->redirect($this->generateUrl('Dgcl_project_default'));
        }

        $entity = new User();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        if ($form->isValid()) {

            $entity->setEnabled(true);
            $em = $this->getDoctrine()->getManager();
            $em->persist($entity);
            $em->flush();

            $this->get('session')->getFlashBag()->add(
                  'notice', $this->get('translator')->trans('message add')
            );

            return $this->redirect($this->generateUrl('Dgcl_user_edit', array('id' => $entity->getId())));
        }

        return $this->render('DgclProjectsBundle:User:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Creates a form to create a Project entity.
     *
     * @param Project $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(User $entity) {

	$params = array();
        
        $form = $this->createForm(new UserType($params), $entity, array(
            'action' => $this->generateUrl('Dgcl_user_create'),
            'method' => 'POST',
        ));
        return $form;
    }

    
    /**
     * Displays a form to edit an existing User entity.
     *
     */
    public function editAction($id) {
        if (!$this->get('security.context')->isGranted('ROLE_ADMIN')) {
            $this->get('session')->getFlashBag()->add(
                    'error', $this->get('translator')->trans('permission denied')
            );
            return $this->redirect($this->generateUrl('Dgcl_project_default'));
        }

        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository('DgclProjectsBundle:User')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find User entity.');
        }

        $editForm = $this->createEditForm($entity);
        
        return $this->render('DgclProjectsBundle:User:edit.html.twig', array(
                    'user' => $entity,
                    'form' => $editForm->createView()
        ));
    }
    
    /**
     * Creates a form to edit a User entity.
     *
     * @param Project $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(User $entity) {

        $params = array();
        
        $form = $this->createForm(new UserType($params), $entity, array(
            'action' => $this->generateUrl('Dgcl_user_update', array('id' => $entity->getId())),
            'method' => 'POST',
        ));

        return $form;
    }
    
    
    /**
     * Edits an existing User entity.
     *
     */
    public function updateAction(Request $request, $id) {

        if (!$this->get('security.context')->isGranted('ROLE_ADMIN')) {
            $this->get('session')->getFlashBag()->add(
                    'error', $this->get('translator')->trans('permission denied')
            );
            return $this->redirect($this->generateUrl('Dgcl_project_default'));
        }


        $em = $this->getDoctrine()->getManager();
        
        $entity = $em->getRepository('DgclProjectsBundle:User')->findOneById($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find User entity.');
        }

        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {

            $em->persist($entity);
            $em->flush();

            $this->get('session')->getFlashBag()->add(
                    'notice', $this->get('translator')->trans('update success')
            );

            return $this->redirect($this->generateUrl('Dgcl_user_edit', array('id' => $entity->getId())));
        }

        return $this->render('DgclProjectsBundle:User:edit.html.twig', array(
                    'user' => $entity,
                    'form' => $editForm->createView()
        ));
    }
    
    
    /**
     * Deletes a User entity.
     *
     */
    public function deleteAction($id) {

        if (!$this->get('security.context')->isGranted('ROLE_ADMIN')) {
            $this->get('session')->getFlashBag()->add(
                    'error', $this->get('translator')->trans('permission denied')
            );
            return $this->redirect($this->generateUrl('Dgcl_project_default'));
        }

        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository('DgclProjectsBundle:User')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find User entity.');
        }

        $em->remove($entity);
        $em->flush();

        $this->get('session')->getFlashBag()->add(
                'notice', $this->get('translator')->trans('delete success')
        );

        return $this->redirect($this->generateUrl('admin_users'));
    }
}

