<?php

namespace Dgcl\ProjectsBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Dgcl\ProjectsBundle\Form\QuestionnaireType;
use Dgcl\ProjectsBundle\Form\PieceJointeType;
use Dgcl\ProjectsBundle\Entity\Questionnaire;
use Dgcl\ProjectsBundle\Entity\PieceJointe;
use Dgcl\ProjectsBundle\Entity\Utils;


/**
 * Indicateurs controller.
 *
 */
class IndicateursController extends Controller {

    public function getCurrentAnnee() {
        return $annee = date('Y') - 1;
    }

    public function getTabs() {

        return $tabs = array(
            'domaine_1' => array('domaine_1_axe_1', 'domaine_1_axe_2', 'domaine_1_axe_3'),
            'domaine_2' => array('domaine_2_axe_1', 'domaine_2_axe_2', 'domaine_2_axe_3'),
            'domaine_3' => array('domaine_3_axe_1', 'domaine_3_axe_2', 'domaine_3_axe_3', 'domaine_3_axe_4'),
        );
    }

    public function getPiecesJointes($count = false){
        
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();

        $annee = $this->getCurrentAnnee();
       
        
        $pieces_jointes = $em->getRepository('DgclProjectsBundle:PieceJointe')->findBy(
                array(
                    'annee' => $annee,
                    'Commune' => $user->getCommune()
                )
        );
        
        if($count){
            return count($pieces_jointes) ;
        }
        
        
        $pieces_jointes_tab = array(); 
        
        foreach ($pieces_jointes as $piece_jointe ) {
            
            $pieces_jointes_tab[ 'indicateur_piece_jointe_' . $piece_jointe->getQuestion()][] = $piece_jointe; 
            
        }
               
        return $pieces_jointes_tab ;
        
        
    }
    
    public function indexAction(Request $request) {

       if (!$this->get('security.context')->isGranted(array('ROLE_COMMUNE'))) {
           /* $this->get('session')->getFlashBag()->add(
                    'error', $this->get('translator')->trans('permission denied')
            );*/
            return $this->redirect($this->generateUrl('Dgcl_project_homepage'));
        }
        
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();

        $dateLimite = Utils::getDateLimite() ;
        
        $annee = $this->getCurrentAnnee();
        $activeDomaine = $request->get('activeDomaine', 1);
        $activeAxe = $request->get('activeAxe', 1);

        $entity = $em->getRepository('DgclProjectsBundle:Questionnaire')->findOneBy(
                array(
                    'annee' => $annee,
                    'Commune' => $user->getCommune()
                )
        );
        
         

        if (!$entity) {
            $entity = new Questionnaire();
        }


        if ($activeDomaine == 'pieces_jointes') {
            $form_questionnaire = $this->createForm(new PieceJointeType());
            $form_questionnaire->handleRequest($request);
        } else {
            $form_questionnaire = $this->createForm(new QuestionnaireType('domaine_' . $activeDomaine . '_axe_' . $activeAxe), $entity);
            $form_questionnaire->handleRequest($request);
        }

        return $this->render('DgclProjectsBundle:Indicateurs:index.html.twig', array(
                    'date_limite' => $dateLimite->format('d/m/Y') ,
                    'pieces_jointes' => $this->getPiecesJointes() ,  
                    'nb_pieces_jointe' => $this->getPiecesJointes(true) , 
                    'tabs' => $this->getTabs(),
                    'annee' => $annee,
                    'entity' => $entity,
                    'activeDomaine' => $activeDomaine,
                    'activeAxe' => $activeAxe,
                    'form_questionnaire' => $form_questionnaire->createView(),
        ));
    }

    public function saveAction(Request $request) {
        
        
        if (!$this->get('security.context')->isGranted('ROLE_COMMUNE')) {
            $this->get('session')->getFlashBag()->add(
                    'error', $this->get('translator')->trans('permission denied')
            );
            return $this->redirect($this->generateUrl('Dgcl_project_default'));
        }
        
        
        $dateLimite = Utils::getDateLimite() ;
        
        if( new \DateTime(date('Y-m-d')) > $dateLimite ){
            
            $this->get('session')->getFlashBag()->add(
                    'error', $this->get('translator')->trans('erreur_date_limite')." " .$dateLimite->format('d/m/Y')
            );
            
            return $this->redirect($this->generateUrl('admin_indicateurs'));
        }
        
        
        
        
        $em = $this->getDoctrine()->getManager();
        $annee = $this->getCurrentAnnee();
        $user = $this->getUser();
        $commune = $user->getCommune();

        $activeDomaine = $request->get('activeDomaine', 1);
        $activeAxe = $request->get('activeAxe', 1);

        if ($activeDomaine == 'pieces_jointes') {

            $entity = new PieceJointe();
            $entity->setAnnee($annee);
            $entity->setCommune($commune);

            $form_questionnaire = $this->createForm(new PieceJointeType(), $entity);
            $form_questionnaire->handleRequest($request);

        } else {

            $entity = $em->getRepository('DgclProjectsBundle:Questionnaire')->findOneBy(
                    array(
                        'annee' => $annee,
                        'Commune' => $commune
                    )
            );

            if (!$entity) {
                $entity = new Questionnaire();
                $entity->setAnnee($annee);
                $entity->setCommune($commune);
            }

            $form_questionnaire = $this->createForm(new QuestionnaireType('domaine_' . $activeDomaine . '_axe_' . $activeAxe), $entity);
            $form_questionnaire->handleRequest($request);
        }

        if ($form_questionnaire->isValid()) {

            if ($activeDomaine == 'pieces_jointes') {
                $fichier = $entity->getNomFichier();
                $nom_fichier = date('Ymdhis') . uniqid() . '.' . $fichier->guessExtension();
                $entity->setNomFichier($nom_fichier) ;
                $entity->setNomFichierOriginale($fichier->getClientOriginalName()) ;
                $fichier->move(Utils::UPLOAD_DIR . '/' . $commune->getIdCommune(). '/'  , $nom_fichier);
            }
            
            $em->persist($entity);
            $em->flush();

            $this->get('session')->getFlashBag()->add(
                    'notice', $this->get('translator')->trans('update success')
            );
        }
        
        $pieces_jointes = $em->getRepository('DgclProjectsBundle:PieceJointe')->findBy(
                array(
                    'annee' => $annee,
                    'Commune' => $user->getCommune()
                )
        );
        
        $pieces_jointes_tab = array(); 
        
        foreach ($pieces_jointes as $piece_jointe ) {
            
            $pieces_jointes_tab[$piece_jointe->getQuestion()][] = $piece_jointe->getNomFichier(); 
            
        }
         
        return $this->render('DgclProjectsBundle:Indicateurs:index.html.twig', array(
                    'date_limite' => $dateLimite->format('d/m/Y') ,
                    'pieces_jointes' => $this->getPiecesJointes() ,   
                    'nb_pieces_jointe' => $this->getPiecesJointes(true) , 
                    'tabs' => $this->getTabs(),
                    'annee' => $annee,
                    'entity' => $entity,
                    'activeDomaine' => $activeDomaine,
                    'activeAxe' => $activeAxe,
                    'form_questionnaire' => $form_questionnaire->createView(),
        ));
    }
    
    public function removePieceJointeAction(Request $request){
        
        if (!$this->get('security.context')->isGranted('ROLE_COMMUNE')) {
            $this->get('session')->getFlashBag()->add(
                    'error', $this->get('translator')->trans('permission denied')
            );
            return $this->redirect($this->generateUrl('Dgcl_project_default'));
        }
        
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();

        $annee = $this->getCurrentAnnee();
        
        $piece_jointe = $em->getRepository('DgclProjectsBundle:PieceJointe')->findOneBy(
                array(
                    'annee' => $annee,
                    'Commune' => $user->getCommune(),
                    'idFichier' => $request->get('id')
                )
        );

        if($piece_jointe){
            
            $em->remove($piece_jointe);
            $em->flush() ;
            
        }else{
             return $this->redirect($this->generateUrl('Dgcl_project_default'));            
        }
               
        return $this->redirect($this->generateUrl('Dgcl_indicateurs_index', array('activeDomaine' => 'pieces_jointes')));            
        
        
    }

}
